<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Studio\V1\Flow\Execution;

use Twilio\InstanceContext;
use Twilio\Values;
use Twilio\Version;

class ExecutionContextContext extends InstanceContext {
	/**
	 * Initialize the ExecutionContextContext
	 *
	 * @param \Twilio\Version $version Version that contains the resource
	 * @param string $flowSid Flow Sid.
	 * @param string $executionSid Execution Sid.
	 *
	 * @return \Twilio\Rest\Studio\V1\Flow\Execution\ExecutionContextContext
	 */
	public function __construct( Version $version, $flowSid, $executionSid ) {
		parent::__construct( $version );

		// Path Solution
		$this->solution = array( 'flowSid' => $flowSid, 'executionSid' => $executionSid, );

		$this->uri = '/Flows/' . rawurlencode( $flowSid ) . '/Executions/' . rawurlencode( $executionSid ) . '/Context';
	}

	/**
	 * Fetch a ExecutionContextInstance
	 *
	 * @return ExecutionContextInstance Fetched ExecutionContextInstance
	 * @throws TwilioException When an HTTP error occurs.
	 */
	public function fetch() {
		$params = Values::of( array() );

		$payload = $this->version->fetch(
			'GET',
			$this->uri,
			$params
		);

		return new ExecutionContextInstance(
			$this->version,
			$payload,
			$this->solution['flowSid'],
			$this->solution['executionSid']
		);
	}

	/**
	 * Provide a friendly representation
	 *
	 * @return string Machine friendly representation
	 */
	public function __toString() {
		$context = array();
		foreach ( $this->solution as $key => $value ) {
			$context[] = "$key=$value";
		}

		return '[Twilio.Studio.V1.ExecutionContextContext ' . implode( ' ', $context ) . ']';
	}
}